// Scenario Data for scenarios 1-4 

/*
This file generates the simulated data data

Change to the folder where this file is saved.
You need to have the scanario parameters stored in ../Scenario_Parameters/

*/

// Change to folder where this file is saved.
//cd "C:\TSD_simulation\Generate_Data"

// background rates
include ../Scenario_Parameters/background_mortality_rate_gompertz.do

set seed 781234102

// Different Scenarios
foreach scen in 1 2 3 4 {
	// Different sample sizes
	foreach ss in 100 500 {
		// Low and medium survival
		foreach S in 1 2 {
		// Different frailty effects
			foreach F in 1 2 {
				include ../Scenario_Parameters/Scenario`scen'_S`S'_F`F'.do
			// dataset counter
				local j 1
				// create folder if does not exist
				mata : st_numscalar("folderexists", direxists("../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/"))
				if !folderexists mkdir ../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'
				
				// generate datasets
				forvalues i = 1/1000 {
					clear
					qui set obs `ss'
					gen double age = rnormal(60,6)
					gen double z = rnormal(0,1)
					
					// disease-specific mortality
					local pmixopt = cond(`scen'==3,"pmix(`pmix')","")
					local mixture = cond(`scen'==3,"mixture","")
					qui survsim td dd, dist(`dist') lambda(`lambda1' `lambda2') gamma(`gamma1' `gamma2') `pmixopt' maxt(3) cov(z `frailty_beta') `mixture'
					// cure model
					if `scen' == 4 {
						gen byte cure = runiform()<=`pi'
						replace td = 3 if cure
					}
					
					// other cause mortality
					// attained age as time-scale so incorporate S(agediag).
					gen double S0 = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*age) - 1))
					gen double lnU = ln(runiform()*S0)
					
					// generate from gompertz and change back to time from diagnosis scale
					gen double toth = ln(-lnU*`gamma_gomp'/`lambda_gomp' + 1)/`gamma_gomp' - age
					qui replace toth = 3 if toth>3
					
					// censoring
					survsim tc dc, dist(exp) lambda(0.1) maxt(3)
					
					// combine disease, other and censoring times
					gen double t = min(td,toth,tc)
					gen byte d = cond((td == tc & toth == tc) | (tc<td & tc<toth),0,cond(td<toth,1,2))
					
					// save and label data 
					keep t d age z 
					label var t "survival"
					label var d "status"
					label define status 0 "censored" 1 "disease" 2 "other", replace
					label values d status
					label var age "age t diagnosis"
					label var z "unmeasured frailty"
					label data "Scenario`scen'_S`S'_SS`ss'_F`F' Sim`j'"

					qui save ../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/sim`j', replace
					local j = `j' + 1
				}
			}	
		}
	}
}
